//------------------------
// PARAMETERS

float gInvRGBScale
<
   string paramClass="intrinsic";
   string paramName="InvRGBScale";
   string paramType="float";
> = 1.0;

float4 gToneMapParamsA
<
   string paramClass="param";
   string paramName="ToneMapParamsA";
> = float4(0,0,0,0);

float4 gToneMapParamsB
<
   string paramClass="param";
   string paramName="ToneMapParamsB";
> = float4(0,0,0,0);

float4 gDitherNoiseTextureUVScale
<
   string paramClass="param";
   string paramName="DitherNoiseUVScale";
> = float4(1,1,0,0);

float gDitherNoiseIntensity
<
   string paramClass="param";
   string paramName="DitherNoiseInten";
   string paramType ="float";
> = 0.01;

sampler gSampler0 : register(s0);
sampler gSampler1 : register(s1);
sampler gSampler2 : register(s2);
sampler gSampler3 : register(s3);

// END PARAMETERS


//---------------------------
// FUNCTION_PS ToneMapPS

uniform sampler2DRect gSampler0;
uniform sampler2DRect gSampler1;
#ifdef STREAKS_ENABLED
uniform sampler2D gSampler2;
#endif
uniform sampler2D gSampler3;

uniform vec4  gToneMapParamsA;
uniform vec4  gToneMapParamsB;
uniform float gInvRGBScale;
uniform vec4  gDitherNoiseTextureUVScale;
uniform float gDitherNoiseIntensity;

void main()
{
   const float gOOPi = 0.3183;

   float Kl  = gToneMapParamsA.x;
   float F   = gToneMapParamsA.y;
   float OOF = gToneMapParamsA.z;
   float G   = gToneMapParamsA.w;
   float R   = gToneMapParamsB.x;
   float M   = gToneMapParamsB.y;

   vec4 radianceSample = texture2DRect(gSampler0, gl_TexCoord[3].st);

#ifdef SCALERGBOUTPUT
   radianceSample.rgb *= gInvRGBScale;
#endif   

   vec3 bloomSample = vec3( texture2DRect(gSampler1, (gl_TexCoord[3].st + vec2(-6.0, 6.0)) / 4.0) );

#ifdef SCALERGBOUTPUT
   bloomSample.rgb *= gInvRGBScale;
#endif      
   
   // rg streaks disabled for age3      
#ifdef STREAKS_ENABLED
   vec3 streakSample = vec3( texture2D(gSampler2, gl_TexCoord[1].st) );
#endif   

   vec3 accum = radianceSample.rgb * gOOPi;
   
   // apply scene intensity, which is derived from the camera's exposure
   accum *= M;

/* Not sure how to compare vec3 accum with scalar Kl
   // apply knee function to intensities
   vec3 knee;
   knee.r = log((accum.r - Kl) * F + 1.0) * OOF + Kl;
   knee.g = log((accum.g - Kl) * F + 1.0) * OOF + Kl;
   knee.b = log((accum.b - Kl) * F + 1.0) * OOF + Kl;

   // switch to linear response if intensity is below the start of the knee curve
   accum = (accum >= Kl) ? knee : accum;
*/

   // Add in blooming (this is a weird place to do it!?)   
   accum += bloomSample; 

#ifdef STREAKS_ENABLED
   // Add in streaks
   accum += streakSample;
#endif   
               
   // gamma correct, then apply midgrey adjustment
   vec3 finalColor;

   finalColor.r = pow(accum.r, G) * R;
   finalColor.g = pow(accum.g, G) * R;
   finalColor.b = pow(accum.b, G) * R;
   
   // apply some dither noise to reduce quantization errors
   finalColor += vec3( texture2D(gSampler3, gl_TexCoord[0].st * gDitherNoiseTextureUVScale.xy) ) * gDitherNoiseIntensity;   
         
   gl_FragColor = vec4(finalColor, 1.0);
}
